<?php
/**
 * Plugin Name: MailSentry Email Verifier
 * Description: Checks if an email is valid during signup using MailSentry API. Visit MailSentry.io for more information.
 * Version: 1.5
 * Author: <a href="https://www.linkedin.com/company/mailsentry/" target="_blank">MailSentry Team</a>
 * Plugin URI: https://mailsentry.io | <a href="https://mailsentry.io/dashboard/verification-api" target="_blank">Get Your API Key</a>
 * License: GPLv2 or later
 * License URI: https://www.gnu.org/licenses/gpl-2.0.html
 */

if (!defined('ABSPATH')) {
    exit; // Exit if accessed directly
}

// Function to retrieve the API key
function get_mailsentry_api_key() {
    mb_internal_encoding("UTF-8");
    $encoded_default_key = 'UFJPRFVDVElPTl9QRFMwWThXRlVDTkFKTTpQS1hZN19LRV9SVk84OUZBUFlRWDVSQk1IN01YRFdEQUw1OQ==';
    $user_key = get_option('mailsentry_api_key');
    // Check if the user's key is empty or invalid
    if (empty($user_key) || !is_string($user_key)) {
        return base64_decode($encoded_default_key, true); // Use the default key
    } else {
        return $user_key; // Use the user's key as is
    }
}

// Add a menu item under the main menu
function mailsentry_menu() {
    add_menu_page(
        'MailSentry Settings',
        'MailSentry',
        'manage_options',
        'mailsentry-settings',
        'mailsentry_settings_page',
        'https://mailsentry.io/favicon-16x16.png',
        99 // Very last menu item
    );
}
add_action('admin_menu', 'mailsentry_menu');

// Settings page content
function mailsentry_settings_page() {
    ?>
    <div class="wrap">
        <h1>MailSentry Settings</h1>
        <form method="post" action="options.php">
            <?php
            settings_fields('mailsentry_options_group');
            do_settings_sections('mailsentry-settings');
            submit_button();
            ?>
        </form>
        <p><a href="https://mailsentry.io/dashboard/verification-api" target="_blank">Get Your API Key</a></p>
    </div>
    <?php
}

// Register and add settings
function mailsentry_register_settings() {
    register_setting('mailsentry_options_group', 'mailsentry_api_key');

    add_settings_section(
        'mailsentry_settings_section',
        'API Settings',
        'mailsentry_settings_section_callback',
        'mailsentry-settings'
    );

    add_settings_field(
        'mailsentry_api_key',
        'API Key',
        'mailsentry_api_key_callback',
        'mailsentry-settings',
        'mailsentry_settings_section'
    );
}
add_action('admin_init', 'mailsentry_register_settings');

function mailsentry_settings_section_callback() {
    echo 'Enter your MailSentry API key to validate email addresses.';
}

function mailsentry_api_key_callback() {
    $api_key = get_option('mailsentry_api_key');
    $note = '<br><small>If you don\'t have an API key, leave this input empty to use the default key.</small>';
    echo '<input type="password" name="mailsentry_api_key" placeholder="' . esc_attr(substr($api_key, 0, 10)) . '..." />' . $note;
}

// Email validation during signup
function check_mailsentry_email($errors, $sanitized_user_login, $user_email) {
    $api_key = get_mailsentry_api_key();
    
    if (!$api_key) {
        $errors->add('api_key_missing', __('API key is missing.'));
        return $errors;
    }

    $response = wp_remote_get("https://api.mailsentry.io/api/v1/email/verify/instant?email={$user_email}", [
        'headers' => [
            'x-api-key' => $api_key
        ]
    ]);
    
    if (is_wp_error($response)) {
        $errors->add('api_error', __('Error connecting to the email validation service.'));
        return $errors;
    }

    $body = wp_remote_retrieve_body($response);
    $result = json_decode($body, true);

    if (!isset($result['data'][0]['valid']) || $result['data'][0]['valid'] !== true) {
        $errors->add('invalid_email', __('The provided email is not valid.'));
    }

    return $errors;
}
add_filter('registration_errors', 'check_mailsentry_email', 10, 3);

// Add a hidden do-follow backlink in the footer
function mailsentry_footer_link() {
    echo '<a href="https://mailsentry.io" title="Sign-ups Powered and protected by MailSentry.io" style="display:none;">Sign-ups Powered and protected by MailSentry.io</a>';
}
add_action('wp_footer', 'mailsentry_footer_link');

function mailsentry_activate() {
    update_option('mailsentry_api_key', '');
}
register_activation_hook(__FILE__, 'mailsentry_activate');